{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 09.09.98 - 14:26:14 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MMSystem, MMObj, MMDSPObj, MMUtils, MMWave, MMCstDlg, MMRegs, MMPCMSup;

type
  TForm1 = class(TForm)
    SrcFile: TMMWaveFile;
    LeftFile: TMMWaveFile;
    Button1: TButton;
    RightFile: TMMWaveFile;
    OpenDialog: TMMWaveOpenDialog;
    procedure Button1Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{ This Demo splits a PCM 16 Bit Stereo file in two Mono files }

procedure TForm1.Button1Click(Sender: TObject);
type
   TChannel = record
      Left : Smallint;
      Right: Smallint;
   end;

var
   i: integer;
   nRead,nBytes: Longint;
   Buf: array[0..4095] of TChannel;
   FName,Ext: string;
   wfx: TWaveFormatEx;

begin
   if not OpenDialog.Execute then exit;

   SrcFile.Wave.FileName := OpenDialog.FileName;
   if (SrcFile.Wave.FormatTag <> WAVE_FORMAT_PCM) or
      (SrcFile.Wave.BitLength <> 16) or
      (SrcFile.Wave.Mode <> mStereo) then
   begin
      MessageDlg('This is not a valid input file!',mtError,[mbOK],0);
      exit;
   end;

   // build the correct Wave Header for the Mono files
   pcmBuildWaveHeader(@wfx,SrcFile.Wave.PWaveFormat.wBitsPerSample,
                           1,
                           SrcFile.Wave.PWaveFormat.nSamplesPerSec);

   // build a unique FileName for left destination: "FName_L.wav"
   FName := SrcFile.Wave.FileName;
   Ext := ExtractFileExt(FName);
   FName := Copy(FName,1,Pos(Ext,FName)-1)+'_L'+Ext;
   // delete the DestFile
   DeleteFile(FName);
   // create the file for the left channel
   LeftFile.Wave.CreateFile(FName,@wfx);

   // build a unique FileName for right destination: "FName_R.wav"
   FName := SrcFile.Wave.FileName;
   Ext := ExtractFileExt(FName);
   FName := Copy(FName,1,Pos(Ext,FName)-1)+'_R'+Ext;
   // delete the DestFile
   DeleteFile(FName);
   // create the file for the right channel
   RightFile.Wave.CreateFile(FName,@wfx);

   // open the source file
   SrcFile.Wave.OpenFile;

   Screen.Cursor := crHourglass;

   nBytes := SrcFile.Wave.DataSize;
   while (nBytes > 0) do
   begin
      // read the data
      nRead := Min(nBytes,sizeOf(Buf));
      nRead := SrcFile.Wave.ReadDataBytes(@Buf,nRead);

      for i := 0 to (nRead div sizeOf(TChannel))-1 do
      begin
         // write out the left and right channel
         LeftFile.Wave.WriteDataBytes(@Buf[i].Left,sizeOf(Buf[i].Left));
         RightFile.Wave.WriteDataBytes(@Buf[i].Right,sizeOf(Buf[i].Right));
      end;

      dec(nBytes,nRead);
   end;

   SrcFile.Wave.CloseFile;
   LeftFile.Wave.CloseFile;
   RightFile.Wave.CloseFile;

   Screen.Cursor := crDefault;
end;

end.
